/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.core.util.ServiceResponseUtils;
import gov.va.med.mhv.usermgmt.service.UserProfileDeactivationReasonServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfileDeactivationReason;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class UserProfileDeactivationUtils {

    private static final Log LOG = LogFactory.getLog(
        UserProfileDeactivationUtils.class);
    
    public static final String STATE_CHANGED_BY_SYSTEM = "System"; 
    
    public static final String MPI_PATIENT_MERGE_NAME = 
        "MVI Merge Request";
    
    public static final String MULTIPLE_ACCOUNTS_RESOLUTION_NAME = 
        "Multiple MHV Accounts Resolution";
    
    //JAZZ Defect# 20309: If there four or more traits update, DO NOT Update the user and deactivate the user.
	public static final String A31_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE_NAME = 
		"A31 possible ICN Mismatch (do not reactivate)";
	
    public static final UserProfileDeactivationReason MPI_PATIENT_MERGE =
        findReason(MPI_PATIENT_MERGE_NAME, true);
    
    public static final UserProfileDeactivationReason 
        MULTIPLE_ACCOUNTS_RESOLUTION = findReason(
        MULTIPLE_ACCOUNTS_RESOLUTION_NAME, true);

	public static final UserProfileDeactivationReason A31_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE = 
		findReason(A31_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE_NAME, false);
	
    public static final UserProfileDeactivationReason findReason(String name) {
        return findReason(name, false);
    }

    private static final UserProfileDeactivationReason findReason(String name,
        boolean createIfNotFound) 
    {
        Precondition.assertNotBlank("name", name);
        
        UserProfileDeactivationReasonServiceResponse response = 
            ServiceDelegateFactory.createUserProfileServiceDelegate().
            findDeactivationReason(name);
        if (ServiceResponseUtils.hasErrorMessages(response)) {
            LOG.fatal("Unable to load UserProfileDeactivationReason "
                + "with name '" + name + "'.");
            return null;
        }
        
        UserProfileDeactivationReason reason = response.getUserProfileDeactivationReason();
        if(reason != null) {
        	return reason;
        }
        
        if(createIfNotFound) {
	        // Try to create a reason instance
	        reason = TransferObjectFactory.
	            createUserProfileDeactivationReason();
	        reason.setName(name);
	        response = ServiceDelegateFactory.
	            createEntityMaintenanceServiceDelegate().save(reason);
	        reason = response.getUserProfileDeactivationReason();
	        if (!ServiceResponseUtils.hasErrorMessages(response) 
	            && (reason != null)) 
	        {
	            return  reason;
	        }
        }
        LOG.fatal("Unable to find and/or create UserProfileDeactivationReason "
            + "with name '" + name + "'.");
        
        return null; // unreachable
    }
    
    private UserProfileDeactivationUtils() {
    }
    
}
